#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

unsigned char serbuf[8] = {0xff, 0x10, 0xff, 0x15, 0xfa, 0xff, 0xff, 0xff};


char xorsum(char *buf, int len)
{
	int i;
	char res = 0xbc;

	for (i=0; i < len; i++)
		if (isalnum(buf[i]))
			res ^= toupper(buf[i]);

	return res;
}

void gennum(char *buf)
{
	long int val;

	randomize();
	val = ((long int)rand()) * 27 + 100000;
	sprintf(buf, "%06lu", val);
}

void genserial()
{
	char name[101], ser[31], buf1[30] = "\0", buf2[4] = "\0";
	int i;

	printf("Enter the name that will appear in your XpertRule info\n> ");
	gets(name);

	serbuf[2] = xorsum(name, strlen(name));

	gennum(buf1);
	sscanf(buf1, "%2x%2x%2x", &serbuf[5], &serbuf[6], &serbuf[7]);

	buf1[0] = 0;
	for (i=1; i<8; i++) {
		sprintf(buf2, "%02X", serbuf[i]);
		strcat(buf1, buf2);
	}
	serbuf[0] = xorsum(buf1, strlen(buf1));
	sprintf(ser, "%02X", serbuf[0]);
	strcat(ser, buf1);

	printf("\nSerial Number : %s\n", ser);
	printf("User Name     : %s\n", name);
	printf("\nEnter the above information into your XpertRule 'Serial# Entry' dialog\n");
}


void main()
{
	printf("XpertRule v3.65 Serial# generator\n\n");
	genserial();
}